﻿import tkinter as tk
from tkinter import messagebox, ttk, scrolledtext, Menu, font
import requests
import threading

# Путь к файлу с токенами
TOKENS_FILE_PATH = "C:\\Users\\1\\Desktop\\VS 2022\\Настройки аккаунтов ВК\\Токены для настроек ВК.txt"
# Путь к файлу для сохранения закрытых аккаунтов
CLOSED_PROFILES_FILE_PATH = "C:\\Users\\1\\Desktop\\VS 2022\\Настройки аккаунтов ВК\\закрытые аккаунты.txt"
# Путь к файлу для сохранения аккаунтов, которым нужны ручные настройки
MANUAL_SETTINGS_FILE_PATH = "C:\\Users\\1\\Desktop\\VS 2022\\Настройки аккаунтов ВК\\вручные настройки.txt"

# Цвета для строк с различными состояниями
CLOSED_PROFILE_COLOR = "#ffcccc"          # Светло-красный цвет для закрытых профилей

# Максимальное количество сообщений в журнале
MAX_LOG_MESSAGES = 50

# Цвета для различных типов сообщений
colors = {
    "info": "#333333",      # Темно-серый цвет для информации
    "success": "#008000",   # Зеленый цвет для успешных действий
    "warning": "#FFA500",   # Оранжевый цвет для предупреждений
    "error": "#FF0000"      # Красный цвет для ошибок
}

# Словарь для сопоставления английских значений с русскими
category_translation = {
    'all': 'Все',
    'friends_of_friends': 'Друзья друзей',
    'friends': 'Друзья',
    'only_me': 'Только я',
    'some': 'Некоторые',
    'nobody': 'Никто',
    'all_except_of_search_engines': 'Все, кроме поисковых систем',
    'vk_users_only': 'Только пользователи VK',
    'see_all_friends': 'Все друзья',
    'closed': 'Закрытый профиль',
    'open': 'Открытый профиль',
    'disabled': '❌ Отключено'  # Добавлен символ для визуального обозначения
}

# Обратный словарь для преобразования русских значений обратно в английские
reverse_category_translation = {v: k for k, v in category_translation.items()}

# Функция для перевода значений на русский
def translate_category(category, reverse=False):
    if reverse:
        return reverse_category_translation.get(category, category)
    else:
        return category_translation.get(category, category)

# Функция для записи в журнал с минималистичным оформлением
def log_message(message, msg_type="info"):
    # Иконки или символы для разных типов сообщений
    icons = {
        "info": "ℹ️",
        "success": "✅",
        "warning": "⚠️",
        "error": "❌"
    }

    # Обрезка длинных сообщений и добавление многоточия
    max_length = 100
    if len(message) > max_length:
        message = message[:max_length] + "..."

    # Форматирование сообщения
    formatted_message = f"{icons.get(msg_type, '')} {message}"
    
    # Очистка старых сообщений, если превышено максимальное количество
    if log_text.index("end-1c").split('.')[0] != '':
        num_lines = int(log_text.index("end-1c").split('.')[0])
        if num_lines >= MAX_LOG_MESSAGES:
            log_text.delete(1.0, 2.0)  # Удаление самой старой строки

    # Запись сообщения в журнал с цветовым оформлением
    log_text.configure(state='normal')  # Разрешить редактирование текстового поля
    log_text.insert(tk.END, formatted_message + '\n', msg_type)
    log_text.configure(state='disabled')  # Запретить редактирование текстового поля
    log_text.yview(tk.END)  # Прокрутить журнал к последнему сообщению

# Функция для применения стилей к журналу
def apply_log_styles():
    log_text.tag_config("info", foreground=colors["info"], font=("Courier", 10))
    log_text.tag_config("success", foreground=colors["success"], font=("Courier", 10))
    log_text.tag_config("warning", foreground=colors["warning"], font=("Courier", 10, "bold"))
    log_text.tag_config("error", foreground=colors["error"], font=("Courier", 10, "bold"))

# Функция для получения списка токенов из файла
def get_tokens_from_file(file_path):
    try:
        with open(file_path, 'r', encoding='utf-8') as file:
            tokens = file.read().splitlines()
        log_message(f"Токены успешно загружены из файла: {file_path}", msg_type="success")
        return tokens
    except Exception as e:
        error_msg = f"Ошибка при чтении файла с токенами: {str(e)}"
        log_message(error_msg, msg_type="error")
        return []

# Функция для создания и очистки новой сессии
def create_session():
    session = requests.Session()
    session.cookies.clear()  # Очистка куки
    return session

# Функция для получения настроек приватности пользователя
def get_privacy_settings(session, token):
    try:
        url = 'https://api.vk.com/method/account.getPrivacySettings'
        params = {
            'access_token': token,
            'v': '5.131'
        }
        response = session.get(url, params=params, timeout=10)
        response.raise_for_status()
        data = response.json()
        if 'error' in data:
            error_msg = f"Ошибка VK API: {data['error']['error_msg']}"
            log_message(error_msg, msg_type="error")
            return None
        return data['response']['settings']
    except requests.exceptions.RequestException as e:
        error_msg = f"Произошла ошибка: {str(e)}"
        log_message(error_msg, msg_type="error")
        return None

# Функция для получения имени и фамилии пользователя
def get_user_name(session, token):
    try:
        url = 'https://api.vk.com/method/users.get'
        params = {
            'access_token': token,
            'v': '5.131',
            'fields': 'first_name,last_name'
        }
        response = session.get(url, params=params, timeout=10)
        response.raise_for_status()
        data = response.json()
        if 'error' in data:
            error_msg = f"Ошибка VK API: {data['error']['error_msg']}"
            log_message(error_msg, msg_type="error")
            return None, None
        if 'response' in data:
            user_info = data['response'][0]
            first_name = user_info.get('first_name', 'Неизвестно')
            last_name = user_info.get('last_name', 'Неизвестно')
            return first_name, last_name
    except requests.exceptions.RequestException as e:
        error_msg = f"Произошла ошибка при получении имени пользователя: {str(e)}"
        log_message(error_msg, msg_type="error")
        return None, None

# Функция для получения типа профиля (открытый или закрытый)
def get_profile_type(session, token):
    try:
        url = 'https://api.vk.com/method/users.get'
        params = {
            'access_token': token,
            'v': '5.131',
            'fields': 'is_closed'
        }
        response = session.get(url, params=params, timeout=10)
        response.raise_for_status()
        data = response.json()
        if 'error' in data:
            error_msg = f"Ошибка VK API: {data['error']['error_msg']}"
            log_message(error_msg, msg_type="error")
            return None
        if 'response' in data:
            user_info = data['response'][0]
            # Определяем "Тип профиля"
            profile_type = "Закрытый" if user_info.get('is_closed', False) else "Открытый"
            return profile_type
    except requests.exceptions.RequestException as e:
        error_msg = f"Произошла ошибка при получении типа профиля: {str(e)}"
        log_message(error_msg, msg_type="error")
        return None

# Новая функция для проверки привязанного телефона
def get_phone_attached(session, token):
    """
    Возвращает True, если к аккаунту привязан телефон (поле 'phone' не пустое).
    Возвращает False, если не привязан или поле отсутствует.
    Возвращает None в случае ошибки.
    """
    try:
        url = 'https://api.vk.com/method/account.getProfileInfo'
        params = {
            'access_token': token,
            'v': '5.131'
        }
        response = session.get(url, params=params, timeout=10)
        response.raise_for_status()
        data = response.json()
        if 'error' in data:
            error_msg = f"Ошибка VK API (phone check): {data['error']['error_msg']}"
            log_message(error_msg, msg_type="error")
            return None
        if 'response' in data:
            phone = data['response'].get('phone', '')
            if phone:
                return True
            else:
                return False
    except requests.exceptions.RequestException as e:
        error_msg = f"Произошла ошибка при проверке телефона: {str(e)}"
        log_message(error_msg, msg_type="error")
        return None

# Функция для добавления данных аккаунта в таблицу
def add_account_to_table(index, user_name, settings, profile_type, phone_attached):
    if not settings:
        log_message(f"Пропуск токена: {user_name} из-за ошибки при получении данных.", msg_type="warning")
        return

    # Словарь для хранения значений настроек
    settings_values = {}
    combobox_data = {}  # Словарь для хранения данных о выпадающих меню

    # Добавление настроек в словарь с обработкой отсутствующих настроек
    for setting in settings:
        key = setting.get('key', 'Нет данных')
        title = setting.get('title', 'Нет данных')
        value = setting.get('value', {}).get('category', 'Нет данных')

        # Перевод значений на русский язык
        translated_value = translate_category(value)
        translated_categories = [translate_category(cat) for cat in setting.get('supported_categories', [])]

        # Добавляем только нужные параметры, кроме "page_access"
        if key in relevant_settings:
            settings_values[title] = translated_value
            if translated_categories:
                combobox_data[title] = translated_categories

    # Добавляем тип профиля и доступ к странице внизу
    settings_values["Тип профиля"] = profile_type
    settings_values["Кому в интернете видна моя страница"] = "Не применимо"

    for setting in settings:
        if setting['key'] == 'page_access':
            value = setting.get('value', {}).get('category', 'Нет данных')
            translated_value = translate_category(value)
            settings_values["Кому в интернете видна моя страница"] = translated_value
            break

    # Обработка отсутствующих настроек
    expected_settings = ["Кто видит комментарии к записям", "Кто может комментировать мои записи"]
    disabled_settings_detected = False  # Флаг для определения, есть ли отключённые настройки
    for expected in expected_settings:
        if expected not in settings_values:
            settings_values[expected] = category_translation.get('disabled', '❌ Отключено')
            combobox_data[expected] = ['Все', 'Друзья', 'Только я', 'Отключено']  # Добавьте поддерживаемые категории
            disabled_settings_detected = True  # Устанавливаем флаг, если настройка отключена

    # Добавляем информацию о привязанном телефоне
    if phone_attached is True:
        settings_values["Телефон привязан"] = "Да"
    elif phone_attached is False:
        settings_values["Телефон привязан"] = "Нет"
    else:
        # Если None, значит произошла ошибка
        settings_values["Телефон привязан"] = "Ошибка / Неизвестно"

    # Обновляем заголовки таблицы, включая имя и фамилию и нумерацию строк
    columns = ["№", "Имя и фамилия"] + list(settings_values.keys())
    if not tree["columns"]:
        tree["columns"] = columns
        for i, column in enumerate(tree["columns"], start=1):
            numbered_column = f"{i}. {column}"
            tree.heading(column, text=numbered_column, anchor="center")
            tree.column(column, width=150, anchor="center")

    # Проверка на отсутствующие колонки (если нужно, можно убрать или оставить для других случаев)
    missing_columns = [column for column in tree["columns"]
                       if column not in ["№", "Имя и фамилия"] and column not in settings_values]
    if missing_columns:
        exempt_columns = ["Кто видит комментарии к записям", "Кто может комментировать мои записи"]
        missing_columns = [col for col in missing_columns if col not in exempt_columns]
        if missing_columns:
            log_message(f"Отсутствуют настройки для колонок: {', '.join(missing_columns)}", msg_type="warning")

    # Формируем список значений для каждой колонки в правильном порядке
    values = []
    for column in tree["columns"]:
        if column == "№":
            values.append(index)
        elif column == "Имя и фамилия":
            values.append(user_name)
        else:
            values.append(settings_values.get(column, ""))

    # Определяем теги для строки
    row_tags = []
    if profile_type == "Закрытый":
        row_tags.append("closed_profile")
    # Здесь мы не используем отдельный тег для отключённых настроек

    # Вставляем строку с соответствующими тегами
    tree.insert("", "end", values=values, tags=tuple(row_tags))

    # Добавляем настройки для выпадающих меню (только один раз при пустом combobox_vars)
    if not combobox_vars:
        for setting_title, categories in combobox_data.items():
            add_combobox(setting_title, categories)

    # Обновление счетчика закрытых профилей
    if profile_type == "Закрытый":
        global closed_profiles_count
        closed_profiles_count += 1
        update_closed_profiles_label()

    # Обновление счетчика аккаунтов с ограниченным доступом к комментариям
    comments_setting = settings_values.get("Кто видит комментарии к записям", "Все")
    if comments_setting != "Все":
        global non_all_comments_count
        non_all_comments_count += 1
        update_non_all_comments_label()

    log_message(f"Данные аккаунта {user_name} успешно добавлены в таблицу.", msg_type="success")

# Функция для добавления выпадающего меню для изменения настроек
def add_combobox(setting_title, categories):
    row = len(combobox_vars) // 3  # По 3 выпадающих меню в строке
    col = (len(combobox_vars) % 3) * 2

    # Метка без слова "Изменить"
    label = tk.Label(combobox_frame, text=setting_title)
    label.grid(row=row, column=col, padx=5, pady=5, sticky='e')

    # Устанавливаем значение по умолчанию "Только я" для определенных настроек
    default_value = (
        "Только я"
        if setting_title in ["Кто видит чужие записи на моей странице", "Кто может оставлять записи на моей странице"]
        else categories[0]
    )

    var = tk.StringVar(value=default_value)
    combobox_vars[setting_title] = var

    combobox = ttk.Combobox(combobox_frame, textvariable=var, values=categories, state="readonly")
    combobox.grid(row=row, column=col + 1, padx=5, pady=5, sticky='w')
    combobox_list[setting_title] = combobox

# Функция для сортировки таблицы по номеру
def sort_table_by_number():
    # Получаем все данные из таблицы
    all_items = []
    for item in tree.get_children():
        try:
            num = int(tree.set(item, "#1"))
            values = tree.item(item, "values")
            tags = tree.item(item, "tags")
            all_items.append((num, values, tags))
        except ValueError:
            log_message(f"Невозможно преобразовать значение в столбце № для элемента {item}.", msg_type="error")
    
    # Сортируем данные по номеру (первый столбец)
    all_items.sort(key=lambda x: x[0])

    # Очищаем таблицу
    tree.delete(*tree.get_children())

    # Вставляем отсортированные данные обратно в таблицу с сохранением тегов
    for item in all_items:
        tree.insert("", "end", values=item[1], tags=item[2])

    log_message("Таблица успешно отсортирована по нумерации.", msg_type="info")

    # Обновление счётчиков после сортировки
    global closed_profiles_count, non_all_comments_count
    closed_profiles_count = 0
    non_all_comments_count = 0
    for item in tree.get_children():
        tags = tree.item(item, "tags")
        values = tree.item(item, "values")
        columns = tree["columns"]

        if "closed_profile" in tags:
            closed_profiles_count += 1
        
        # Проверка настройки "Кто видит комментарии к записям"
        # Нужно найти индекс колонки "Кто видит комментарии к записям"
        if "Кто видит комментарии к записям" in columns:
            idx = columns.index("Кто видит комментарии к записям")
            comments_setting = values[idx]
            if comments_setting != "Все":
                non_all_comments_count += 1

    update_closed_profiles_label()
    update_non_all_comments_label()

# Функция для загрузки настроек для каждого аккаунта в отдельном потоке
def load_account_settings_thread(token, index):
    session = create_session()
    first_name, last_name = get_user_name(session, token)
    if first_name is None and last_name is None:
        log_message(f"Не удалось получить имя пользователя для токена {index}.", msg_type="error")
        return
    user_name = f"{first_name} {last_name}"

    # Получаем настройки приватности
    settings = get_privacy_settings(session, token)
    # Получаем тип профиля
    profile_type = get_profile_type(session, token)
    # Проверяем, привязан ли телефон
    phone_attached = get_phone_attached(session, token)

    # Добавляем в таблицу
    root.after(0, add_account_to_table, index, user_name, settings, profile_type, phone_attached)

# Функция для загрузки настроек в отдельном потоке
def load_settings_thread():
    log_message("Загрузка настроек приватности и типа профиля для всех токенов...", msg_type="info")
    tokens = get_tokens_from_file(TOKENS_FILE_PATH)
    if not tokens:
        log_message("Нет доступных токенов для загрузки настроек.", msg_type="warning")
        update_token_count_label(0)
        update_closed_profiles_label()
        update_non_all_comments_label()
        return

    # Обновление метки количества токенов
    update_token_count_label(len(tokens))

    # Очистка таблицы перед добавлением новых данных
    tree.delete(*tree.get_children())

    # Очистка фрейма с выпадающими меню
    for widget in combobox_frame.winfo_children():
        widget.destroy()
    combobox_vars.clear()
    combobox_list.clear()

    # Сброс счётчиков
    global closed_profiles_count, non_all_comments_count
    closed_profiles_count = 0
    non_all_comments_count = 0
    update_closed_profiles_label()
    update_non_all_comments_label()

    # Запуск потоков для каждого токена
    threads = []
    for index, token in enumerate(tokens, start=1):
        thread = threading.Thread(target=load_account_settings_thread, args=(token, index))
        thread.start()
        threads.append(thread)

    # Ожидание завершения всех потоков и сортировка таблицы
    for thread in threads:
        thread.join()

    root.after(0, sort_table_by_number)

def save_changes_thread():
    log_message("Сохранение изменений настроек приватности для всех аккаунтов...", msg_type="info")
    tokens = get_tokens_from_file(TOKENS_FILE_PATH)

    if not tokens:
        log_message("Нет доступных токенов для сохранения изменений.", msg_type="warning")
        return

    for token in tokens:
        session = create_session()
        first_name, last_name = get_user_name(session, token)
        if first_name is None and last_name is None:
            log_message(f"Не удалось получить имя пользователя для токена.", msg_type="error")
            continue
        user_name = f"{first_name} {last_name}"
        
        settings = get_privacy_settings(session, token)
        if settings is None:
            log_message(f"Ошибка при получении настроек для {user_name}. Пропуск...", msg_type="error")
            continue

        for column, var in combobox_vars.items():
            selected_value = var.get()
            translated_value = translate_category(selected_value, reverse=True)

            # Поиск настройки в `settings`
            for setting in settings:
                if setting['title'] == column:
                    key = setting['key']
                    
                    # Проверка на наличие значения в списке поддерживаемых категорий
                    supported_categories = setting.get('supported_categories', [])
                    if translated_value not in supported_categories:
                        log_message(f"Ошибка: Значение '{translated_value}' не поддерживается для настройки '{setting['title']}'. Поддерживаемые значения: {supported_categories}", msg_type="error")
                        continue
                    
                    # Обновить настройку через VK API
                    result = set_privacy_setting(session, key, translated_value, token)
                    if result:
                        log_message(f"Настройка '{setting['title']}' успешно обновлена на '{selected_value}' для {user_name}.", msg_type="success")

    # Сообщение о завершении работы после обработки всех токенов
    log_message("Все изменения для всех аккаунтов успешно сохранены. Работа завершена.", msg_type="success")

# Функция для сохранения закрытых аккаунтов в файл
def save_closed_profiles_thread():
    log_message("Сохранение закрытых профилей в файл...", msg_type="info")
    tokens = get_tokens_from_file(TOKENS_FILE_PATH)
    if not tokens:
        log_message("Нет доступных токенов для сохранения закрытых профилей.", msg_type="warning")
        return

    closed_profiles = []

    # Проход по всем элементам таблицы и сбор закрытых профилей
    for item in tree.get_children():
        if "closed_profile" in tree.item(item, "tags"):
            user_name = tree.item(item, "values")[1]  # "Имя и фамилия" находится во втором столбце
            closed_profiles.append(user_name)
            log_message(f"Закрытый профиль добавлен: {user_name}", msg_type="success")

    if closed_profiles:
        try:
            with open(CLOSED_PROFILES_FILE_PATH, 'w', encoding='utf-8') as file:
                for profile in closed_profiles:
                    file.write(profile + '\n')
            log_message("Все закрытые профили успешно сохранены.", msg_type="success")
        except Exception as e:
            log_message(f"Ошибка при сохранении закрытых профилей: {str(e)}", msg_type="error")
    else:
        log_message("Нет закрытых профилей для сохранения.", msg_type="info")

    # Обновление метки количества закрытых профилей
    update_closed_profiles_label()

# Функция для сохранения аккаунтов с ручными настройками в файл
def save_manual_settings_thread():
    log_message("Сохранение аккаунтов с ручными настройками в файл...", msg_type="info")
    tokens = get_tokens_from_file(TOKENS_FILE_PATH)
    if not tokens:
        log_message("Нет доступных токенов для сохранения аккаунтов с ручными настройками.", msg_type="warning")
        return

    manual_settings_accounts = []

    # Проход по всем элементам таблицы и сбор аккаунтов, которым нужны ручные настройки
    for item in tree.get_children():
        values = tree.item(item, "values")
        # Нужно найти индекс настройки "Кто видит комментарии к записям"
        if "Кто видит комментарии к записям" in tree["columns"]:
            idx = tree["columns"].index("Кто видит комментарии к записям")
            comments_setting = values[idx]
            if comments_setting != "Все":
                user_name = values[1]  # "Имя и фамилия" находится во втором столбце
                manual_settings_accounts.append(user_name)
                log_message(f"Аккаунту требуется ручная настройка: {user_name}", msg_type="success")

    if manual_settings_accounts:
        try:
            with open(MANUAL_SETTINGS_FILE_PATH, 'w', encoding='utf-8') as file:
                for account in manual_settings_accounts:
                    file.write(account + '\n')
            log_message("Все аккаунты, которым нужны ручные настройки, успешно сохранены.", msg_type="success")
        except Exception as e:
            log_message(f"Ошибка при сохранении аккаунтов с ручными настройками: {str(e)}", msg_type="error")
    else:
        log_message("Нет аккаунтов, которым нужны ручные настройки, для сохранения.", msg_type="info")

# Функция для изменения типа профиля (открытый/закрытый)
def set_profile_type(session, is_closed, token):
    try:
        url = 'https://api.vk.com/method/account.setProfileInfo'
        params = {
            'is_closed': is_closed,
            'access_token': token,
            'v': '5.131'
        }
        response = session.get(url, params=params, timeout=10)
        response.raise_for_status()
        data = response.json()
        if 'error' in data:
            error_msg = f"Ошибка VK API при изменении типа профиля: {data['error']['error_msg']}"
            log_message(error_msg, msg_type="error")
            return False
        return True
    except requests.exceptions.RequestException as e:
        error_msg = f"Произошла ошибка при изменении типа профиля: {str(e)}"
        log_message(error_msg, msg_type="error")
        return False

# Функция для обновления настройки приватности через VK API
def set_privacy_setting(session, key, value, token):
    try:
        url = 'https://api.vk.com/method/account.setPrivacy'
        params = {
            'key': key,
            'value': value,
            'access_token': token,
            'v': '5.131'
        }
        response = session.get(url, params=params, timeout=10)
        response.raise_for_status()
        data = response.json()
        if 'error' in data:
            error_msg = f"Ошибка VK API при обновлении настройки {key}: {data['error']['error_msg']}"
            log_message(error_msg, msg_type="error")
            return False
        log_message(f"Настройка {key} успешно обновлена на {value}.", msg_type="success")
        return True
    except requests.exceptions.RequestException as e:
        error_msg = f"Произошла ошибка при обновлении настройки {key}: {str(e)}"
        log_message(error_msg, msg_type="error")
        return False

# Функция для копирования выделенного текста из журнала
def copy_log_text(event=None):
    try:
        selected_text = log_text.selection_get()
        root.clipboard_clear()
        root.clipboard_append(selected_text)
    except tk.TclError:
        pass  # Ничего не делать, если нет выделенного текста

# Функция для копирования имени и фамилии из таблицы
def copy_selected_name(event=None):
    selected_items = tree.selection()
    if not selected_items:
        return
    names = []
    for item in selected_items:
        values = tree.item(item, "values")
        if len(values) >= 2:
            names.append(values[1])  # "Имя и фамилия" находится во втором столбце
    if names:
        names_text = "\n".join(names)
        root.clipboard_clear()
        root.clipboard_append(names_text)
        log_message("Имя и фамилия скопированы в буфер обмена.", msg_type="success")

# Функция для создания контекстного меню в журнале
def create_log_context_menu():
    context_menu = Menu(log_text, tearoff=0)
    context_menu.add_command(label="Копировать", command=copy_log_text)
    return context_menu

# Функция для создания контекстного меню для таблицы
def create_tree_context_menu():
    context_menu = Menu(tree, tearoff=0)
    context_menu.add_command(label="Копировать Имя и Фамилию", command=copy_selected_name)
    return context_menu

# Функция для обновления метки количества токенов
def update_token_count_label(count):
    token_count_label.config(text=f"Количество токенов: {count}")

# Функция для обновления метки количества закрытых профилей
def update_closed_profiles_label():
    closed_profiles_label.config(text=f"Количество закрытых аккаунтов: {closed_profiles_count}")

# Функция для обновления метки количества аккаунтов, которым нужны ручные настройки
def update_non_all_comments_label():
    non_all_comments_label.config(text=f"Аккаунты, которым нужны вручные настройки: {non_all_comments_count}")

# Инициализация окна приложения
root = tk.Tk()
root.title("Настройки приватности VK")
root.geometry("1600x800")  # Увеличенная высота окна для дополнительных меток и кнопок

# Рамка для ввода данных и статуса
frame_input = tk.Frame(root)
frame_input.pack(pady=10, fill=tk.X, padx=10)

# Кнопка для загрузки настроек
button_load = tk.Button(frame_input, text="Загрузить настройки", command=lambda: threading.Thread(target=load_settings_thread).start())
button_load.pack(side=tk.LEFT, padx=5)

# Кнопка для сохранения изменений
button_save = tk.Button(frame_input, text="Сохранить изменения", command=lambda: threading.Thread(target=save_changes_thread).start())
button_save.pack(side=tk.LEFT, padx=5)

# Кнопка для сохранения закрытых профилей
button_save_closed_profiles = tk.Button(frame_input, text="Сохранить закрытые профили", command=lambda: threading.Thread(target=save_closed_profiles_thread).start())
button_save_closed_profiles.pack(side=tk.LEFT, padx=5)

# Кнопка для сохранения аккаунтов с ручными настройками
button_save_manual_settings = tk.Button(frame_input, text="Аккаунты с ручными настройками", command=lambda: threading.Thread(target=save_manual_settings_thread).start())
button_save_manual_settings.pack(side=tk.LEFT, padx=5)

# Рамка для отображения количества токенов и закрытых аккаунтов
frame_status = tk.Frame(root)
frame_status.pack(pady=5, fill=tk.X, padx=10)

# Метка для количества токенов
token_count_label = tk.Label(frame_status, text="Количество токенов: 0", font=("Arial", 10))
token_count_label.pack(side=tk.LEFT, padx=10)

# Глобальный счётчик закрытых профилей
closed_profiles_count = 0

# Метка для количества закрытых аккаунтов
closed_profiles_label = tk.Label(frame_status, text="Количество закрытых аккаунтов: 0", font=("Arial", 10))
closed_profiles_label.pack(side=tk.LEFT, padx=10)

# Глобальный счётчик аккаунтов с ограниченным доступом к комментариям
non_all_comments_count = 0

# Метка для количества аккаунтов, которым нужны ручные настройки
non_all_comments_label = tk.Label(frame_status, text="Аккаунты, которым нужны ручные настройки: 0", font=("Arial", 10))
non_all_comments_label.pack(side=tk.LEFT, padx=10)

# Фрейм для размещения combobox с использованием grid
combobox_frame = tk.Frame(root)
combobox_frame.pack(pady=10, padx=10, fill=tk.X)

# Рамка для таблицы и скроллинг
frame_table = tk.Frame(root)
frame_table.pack(fill=tk.BOTH, expand=True, padx=10)

# Горизонтальный скроллбар
scrollbar_x = tk.Scrollbar(frame_table, orient=tk.HORIZONTAL)
scrollbar_x.pack(side=tk.BOTTOM, fill=tk.X)

# Вертикальный скроллбар
scrollbar_y = tk.Scrollbar(frame_table, orient=tk.VERTICAL)
scrollbar_y.pack(side=tk.RIGHT, fill=tk.Y)

# Настройка таблицы для отображения данных
tree = ttk.Treeview(frame_table, show="headings", height=15, xscrollcommand=scrollbar_x.set, yscrollcommand=scrollbar_y.set)

scrollbar_x.config(command=tree.xview)
scrollbar_y.config(command=tree.yview)

# Добавление тегов для строк с различными состояниями
tree.tag_configure('closed_profile', background=CLOSED_PROFILE_COLOR)

tree.pack(fill=tk.BOTH, expand=True)

# Привязка контекстного меню к таблице
tree_context_menu = create_tree_context_menu()
tree.bind("<Button-3>", lambda event: tree_context_menu.post(event.x_root, event.y_root))

# Текстовое поле для отображения журнала
log_frame = tk.Frame(root)
log_frame.pack(fill=tk.BOTH, expand=True, pady=10, padx=10)
log_text = scrolledtext.ScrolledText(log_frame, wrap=tk.WORD, height=10, state='disabled', font=("Courier", 10))
log_text.pack(fill=tk.BOTH, expand=True)

# Применение стилей к журналу
apply_log_styles()

# Создание контекстного меню для текстового поля журнала
log_context_menu = create_log_context_menu()
log_text.bind("<Button-3>", lambda event: log_context_menu.post(event.x_root, event.y_root))

# Список релевантных настроек, убран "page_access"
relevant_settings = [
    "profile",      # Кто видит основную информацию моей страницы
    "replies_view", # Кто видит комментарии к записям
    "status_replies",  # Кто может комментировать мои записи
    "mail_send",    # Кто может писать мне личные сообщения
    "wall_send",    # Кто может оставлять записи на моей странице
    "wall"          # Кто видит чужие записи на моей странице
]

# Словарь для хранения переменных StringVar для каждого выпадающего меню
combobox_vars = {}
combobox_list = {}

# Запуск основного цикла приложения
root.mainloop()
